/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.data;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.client.renderers.GlobeTextureManager;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncGlobeDataPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.world.data.GlobeDataGenerator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.network.PacketDistributor;

public class GlobeData
extends SavedData {
    private static final int TEXTURE_H = 16;
    private static final int TEXTURE_W = 32;
    public static final String DATA_NAME = "globe_data";
    public final byte[][] globePixels;
    public final long seed;
    private static GlobeData CLIENT_SIDE_INSTANCE = null;

    public GlobeData(long seed) {
        this.seed = seed;
        this.globePixels = GlobeDataGenerator.generate(this.seed);
    }

    public GlobeData(CompoundTag tag) {
        this.globePixels = new byte[32][16];
        for (int i = 0; i < 32; ++i) {
            this.globePixels[i] = tag.m_128463_("colors_" + i);
        }
        this.seed = tag.m_128454_("seed");
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        for (int i = 0; i < this.globePixels.length; ++i) {
            nbt.m_128382_("colors_" + i, this.globePixels[i]);
        }
        nbt.m_128356_("seed", this.seed);
        return nbt;
    }

    public void sendToClient(Level world) {
        this.m_77762_();
        if (!world.f_46443_) {
            NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientBoundSyncGlobeDataPacket(this));
        }
    }

    @Nullable
    public static GlobeData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            return (GlobeData)world.m_142572_().m_129783_().m_8895_().m_164861_(GlobeData::new, () -> new GlobeData(server.m_7328_()), DATA_NAME);
        }
        return CLIENT_SIDE_INSTANCE;
    }

    public static void set(ServerLevel level, GlobeData pData) {
        level.m_142572_().m_129783_().m_8895_().m_164855_(DATA_NAME, (SavedData)pData);
    }

    public static void setClientData(GlobeData data) {
        CLIENT_SIDE_INSTANCE = data;
        GlobeTextureManager.refreshTextures();
    }

    public static void sendGlobeData(PlayerEvent.PlayerLoggedInEvent event) {
        GlobeData data;
        if (!event.getPlayer().f_19853_.f_46443_ && (data = GlobeData.get(event.getPlayer().f_19853_)) != null) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getPlayer()), (Object)new ClientBoundSyncGlobeDataPacket(data));
        }
    }
}

